package cn.ibizlab.util.domain;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Data
@JsonInclude(Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@AllArgsConstructor
@ApiModel("文件列表")
public class FileListDto extends ArrayList<FileDto>
{

    @Override
    public String toString() {
        List<Map> list=new ArrayList<>();
        this.forEach(item->{
            Map map=new LinkedHashMap();
            map.putAll(item.getExtensionparams());
            map.put("id",item.getId());
            map.put("name",item.getName());
        });
        return JSON.toJSONString(list);
    }
}